/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.workflow.VWBaseFieldTableModel;
import filenet.vw.toolkit.design.property.workflow.VWTableItemWrapper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import java.util.Vector;
import javax.swing.Icon;

public final class VWWorkflowGroupTableModel
extends VWBaseFieldTableModel
implements IVWPropertyChangeListener {
    private static final int NUM_COLUMNS = 3;
    public static final int COL_SOURCE = 0;
    public static final int COL_NAME = 1;
    public static final int COL_DESCRIPTION = 2;
    public static final int COL_PARTICIPANTS = 3;
    private VWParticipant[] m_dummyParticipants = null;
    private String m_dummyDescription = "";

    public VWWorkflowGroupTableModel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
        try {
            this.m_dummyParticipants = new VWParticipant[0];
            this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void copyItem(int nRowIndex) {
        block6: {
            try {
                VWFieldDefinition fieldDef;
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.getValue() != null && (fieldDef = (VWFieldDefinition)wrapper.getValue()) != null && this.m_authPropertyData != null && this.m_authPropertyData.getWorkflowDefinition() != null) {
                    VWParticipant[] participants = null;
                    Object value = fieldDef.getValue();
                    if (value instanceof VWParticipant[]) {
                        participants = (VWParticipant[])value;
                    }
                    if (participants == null) {
                        participants = new VWParticipant[]{};
                    }
                    String copyOfString = VWResource.s_copyOfFieldName.toString(fieldDef.getName());
                    VWFieldDefinition newFieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingObject(copyOfString, participants);
                    if (newFieldDef != null) {
                        newFieldDef.setDescription(fieldDef.getDescription());
                        newFieldDef.setMergeType(fieldDef.getMergeType());
                        this.m_authPropertyData.resetFieldCache();
                        this.m_authPropertyData.setDirty();
                        this.m_rowData.addElement(new VWTableItemWrapper(0, newFieldDef));
                        nRowIndex = this.getRowCount() - 2;
                        this.fireTableRowsInserted(nRowIndex, nRowIndex);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(newFieldDef);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 558);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void deleteItem(int nRowIndex) {
        block6: {
            try {
                VWFieldDefinition fieldDef;
                if (!this.canDeleteRow(nRowIndex)) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.canDelete() && (fieldDef = (VWFieldDefinition)wrapper.getValue()) != null) {
                    this.m_authPropertyData.getWorkflowDefinition().deleteField(fieldDef.getName());
                    this.m_authPropertyData.resetFieldCache();
                    this.m_authPropertyData.setDirty();
                    if (wrapper.isOverridden()) {
                        wrapper.deleteOverriddenValue();
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    } else {
                        this.m_rowData.removeElementAt(nRowIndex);
                        this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(fieldDef);
                        this.onRemovedFields(this.m_changedItems);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 560);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void reinitialize() {
        try {
            super.reinitialize();
            if (this.m_authPropertyData != null) {
                int i;
                VWFieldDefinition fieldDef;
                if (this.m_authPropertyData.getShowInheritedProperties()) {
                    VWFieldDefinition[] fieldDefs;
                    fieldDef = this.m_authPropertyData.getField("F_Trackers", 2);
                    if (fieldDef != null) {
                        this.m_rowData.addElement(new VWTableItemWrapper(1, fieldDef));
                    }
                    if ((fieldDefs = this.m_authPropertyData.getFields(2)) != null) {
                        for (i = 0; i < fieldDefs.length; ++i) {
                            if (!fieldDefs[i].isArray() || fieldDefs[i].getFieldType() != 64) continue;
                            this.m_rowData.addElement(new VWTableItemWrapper(1, fieldDefs[i]));
                        }
                    }
                }
                if ((fieldDef = this.m_authPropertyData.getField("F_Trackers", 1)) != null) {
                    int nIndex = this.findIndex(fieldDef.getName());
                    if (nIndex != -1) {
                        this.overrideTableItem(nIndex, fieldDef);
                    } else {
                        this.m_rowData.addElement(new VWTableItemWrapper(0, fieldDef));
                    }
                } else {
                    try {
                        if (this.findIndex("F_Trackers") == -1) {
                            fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingObject("F_Trackers", new VWParticipant[0]);
                            this.m_rowData.addElement(new VWTableItemWrapper(0, fieldDef));
                        }
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                    }
                }
                VWFieldDefinition[] fieldDefs = this.m_authPropertyData.getFields(1);
                if (fieldDefs != null) {
                    for (i = 0; i < fieldDefs.length; ++i) {
                        if (!fieldDefs[i].isArray() || fieldDefs[i].getFieldType() != 64) continue;
                        int nIndex = this.findIndex(fieldDefs[i].getName());
                        if (nIndex != -1) {
                            this.overrideTableItem(nIndex, fieldDefs[i]);
                            continue;
                        }
                        this.m_rowData.addElement(new VWTableItemWrapper(0, fieldDefs[i]));
                    }
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean canDeleteRow(int nRowIndex) {
        if (nRowIndex == this.getRowCount() - 1) {
            return false;
        }
        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
        if (wrapper != null) {
            VWFieldDefinition fieldDef;
            if (!this.m_authPropertyData.getShowInheritedProperties() && (fieldDef = (VWFieldDefinition)wrapper.getValue()) != null && VWStringUtils.compare(fieldDef.getName(), "F_Trackers") == 0) {
                return false;
            }
            return wrapper.canDelete();
        }
        return false;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 0: {
                return Icon.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return VWParticipant[].class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3 - this.m_nColumnIndexOffset;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                return VWResource.s_nameStr;
            }
            case 2: {
                return VWResource.s_descriptionStr;
            }
            case 3: {
                return VWResource.s_participants;
            }
        }
        return null;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        VWFieldDefinition fieldDef = null;
        try {
            VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
            if (wrapper != null && wrapper.getValue() != null) {
                fieldDef = (VWFieldDefinition)wrapper.getValue();
            }
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 0: {
                    if (wrapper == null) break;
                    return wrapper.getStateIcon();
                }
                case 1: {
                    if (fieldDef != null) {
                        return fieldDef.getName();
                    }
                    return "";
                }
                case 2: {
                    if (fieldDef != null) {
                        return fieldDef.getDescription();
                    }
                    return this.m_dummyDescription;
                }
                case 3: {
                    if (fieldDef != null) {
                        Object value = fieldDef.getValue();
                        if (value != null) {
                            if (value instanceof VWParticipant[]) {
                                return (VWParticipant[])value;
                            }
                            if (value instanceof String) {
                                return null;
                            }
                        }
                        break;
                    }
                    return this.m_dummyParticipants;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                String name = (String)this.getValueAt(nRowIndex, nColumnIndex);
                if (name != null && VWStringUtils.compare(name, "F_Trackers") == 0) {
                    return false;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    return wrapper.isLocal();
                }
                return true;
            }
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        if (!this.isCellEditable(nRowIndex, nColumnIndex)) {
            return;
        }
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                this.onUpdateName(aValue, nRowIndex);
                break;
            }
            case 2: {
                this.onUpdateDescription(aValue, nRowIndex);
                break;
            }
            case 3: {
                this.onUpdateParticipants(aValue, nRowIndex);
            }
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        switch (event.getID()) {
            case 558: {
                if (event.getSource() == this) break;
                this.reinitialize();
            }
        }
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        block13: {
            VWFieldDefinition fieldDef = null;
            try {
                if (aValue == null || !(aValue instanceof String)) {
                    return;
                }
                String newName = (String)aValue;
                if (newName.length() == 0) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.getValue() != null) {
                    fieldDef = (VWFieldDefinition)wrapper.getValue();
                }
                if (fieldDef != null) {
                    if (VWStringUtils.compare(fieldDef.getName(), "F_Trackers") == 0) {
                        return;
                    }
                    String[] fieldNames = new String[]{fieldDef.getName(), newName};
                    fieldDef.setName(newName);
                    this.m_authPropertyData.setDirty();
                    this.fireTableCellUpdated(nRowIndex, this.getActualColumnIndex(1));
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(fieldNames[0]);
                    this.m_changedItems.addElement(fieldNames[1]);
                    this.onRenamedField(this.m_changedItems);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 561);
                } else {
                    if (this.m_authPropertyData.getField(newName) != null) {
                        String message = VWResource.s_fieldExists.toString(newName);
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), message, 1);
                        return;
                    }
                    if (this.m_dummyParticipants == null) {
                        this.m_dummyParticipants = new VWParticipant[0];
                    }
                    if ((fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingObject(newName, this.m_dummyParticipants)) != null) {
                        fieldDef.setDescription(this.m_dummyDescription);
                        if (fieldDef.isArray()) {
                            fieldDef.setMergeType(6);
                        } else {
                            fieldDef.setMergeType(3);
                        }
                        this.m_authPropertyData.resetFieldCache();
                        this.m_authPropertyData.setDirty();
                        this.m_dummyParticipants = new VWParticipant[0];
                        this.m_dummyDescription = "";
                        this.m_rowData.addElement(new VWTableItemWrapper(0, fieldDef));
                        this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(fieldDef);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 558);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block13;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateParticipants(Object aValue, int nRowIndex) {
        VWParticipant[] participants = null;
        VWFieldDefinition fieldDef = null;
        try {
            try {
                participants = aValue == null || !(aValue instanceof VWParticipant[]) ? new VWParticipant[]{} : (VWParticipant[])aValue;
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.getValue() != null) {
                    fieldDef = (VWFieldDefinition)wrapper.getValue();
                }
                if (fieldDef != null) {
                    if (wrapper.isInherited()) {
                        int nMergeType = fieldDef.getMergeType();
                        String description = fieldDef.getDescription();
                        fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingObject(fieldDef.getName(), participants);
                        fieldDef.setMergeType(nMergeType);
                        fieldDef.setDescription(description);
                        wrapper.overrideValue(fieldDef);
                    } else {
                        fieldDef.setValue(participants);
                    }
                    this.m_authPropertyData.setDirty();
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(fieldDef);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 559);
                }
                this.m_dummyParticipants = participants;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData != null) {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                }
                Object var9_10 = null;
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                return;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            throw throwable;
        }
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateDescription(Object aValue, int nRowIndex) {
        block13: {
            block12: {
                VWFieldDefinition fieldDef = null;
                try {
                    try {
                        block15: {
                            block14: {
                                if (aValue == null) break block14;
                                if (aValue instanceof String) break block15;
                            }
                            Object var8_4 = null;
                            break block12;
                        }
                        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                        if (wrapper != null && wrapper.getValue() != null) {
                            fieldDef = (VWFieldDefinition)wrapper.getValue();
                        }
                        if (fieldDef != null) {
                            if (wrapper.isInherited()) {
                                String currentDesc = fieldDef.getDescription();
                                if (currentDesc == null || VWStringUtils.compare(aValue.toString(), currentDesc) != 0) {
                                    int nMergeType = fieldDef.getMergeType();
                                    fieldDef = this.m_authPropertyData.getWorkflowDefinition().createFieldUsingObject(fieldDef.getName(), fieldDef.getValue());
                                    fieldDef.setMergeType(nMergeType);
                                    fieldDef.setDescription(aValue.toString());
                                    wrapper.overrideValue(fieldDef);
                                }
                            } else {
                                fieldDef.setDescription(aValue.toString());
                            }
                            this.m_authPropertyData.setDirty();
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(fieldDef);
                            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 559);
                            break block13;
                        }
                        this.m_dummyDescription = (String)aValue;
                        break block13;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        Object var8_6 = null;
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    throw throwable;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        Object var8_5 = null;
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }
}

